////////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) since 1999. VASCO DATA SECURITY
// All rights reserved. http://www.vasco.com
//
////////////////////////////////////////////////////////////////////////////////

#import <Foundation/Foundation.h>
NS_ASSUME_NONNULL_BEGIN

/**
 * The {@link OrchestrationUser} object represent the activated user
 */

NS_REFINED_FOR_SWIFT
@interface OrchestrationUser : NSObject

- (instancetype)init NS_UNAVAILABLE;
+ (instancetype)new NS_UNAVAILABLE;

- (instancetype)initWithIdentifier:(NSString *)identifier domain:(NSString *)domain;
- (instancetype)initWithIdentifier:(NSString *)identifier;

/**
 * The user identifier
 * @return the user identifier
 */
@property (nonatomic, strong) NSString *identifier;

/**
 * The user domain
 * @return the user domain
 */
@property (nonatomic, strong) NSString *domain;

@end

NS_ASSUME_NONNULL_END
